(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27281,       1008]*)
(*NotebookOutlinePosition[     28211,       1039]*)
(*  CellTagsIndexPosition[     28167,       1035]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Formal Series Solution: \n",
  StyleBox["Ordinary Point ",
    FontSize->18]
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Modified 4/12/98 to be compatible with V 3.0, C. C. Ross
Modified 4/8/2000 to be compatible with V 4.0, C. C. Ross\
\>", "Text",
  FontSize->9],

Cell[TextData[{
  "This notebook takes advantage of the fact that Sum does not evaluate when \
the terms (summands) are not known. We can therefore perform manipulations on \
the unevaluated arguments (indices, powers of x, cofficients, etc.).\nYellow \
",
  StyleBox["Boxes", "InlineFormula"],
  " denote ",
  StyleBox["required",
    FontWeight->"Bold"],
  " input. \n",
  StyleBox["Use shift-Enter to select next cell for evaluation.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["\n",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["This guarantees that you do not miss any cells that need to be \
evaluated",
    FontVariations->{"Underline"->True}],
  ".\n\nThroughout, the symbol \[Omega] is used to denote \[Infinity]."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["When asked to evaluate ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["Initialization Cells",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0],
    FontVariations->{"Underline"->True}],
  StyleBox[", respond 'Yes.'",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData["The Differential Operator & Assumed solution y[x]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[x, y, v, Op]\)], "Input"],

Cell[CellGroupData[{

Cell["The Operator", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Op[x_, 
        v_] = \(\(v'\)'\)[
          x] + \((x\^2 + 2  x)\)\ \(v'\)[x] + \((x + 4)\)\ v[x]\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    RowBox[{\(\((4 + x)\)\ v[x]\), "+", 
      RowBox[{\((2\ x + x\^2)\), " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["v", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["For this notebook to work correctly",
    FontWeight->"Bold"],
  ", the result of executing the next cell MUST be \n             ",
  StyleBox["{Protected, ReadProtected}",
    FontFamily->"Courier"],
  ".\n If not, ",
  StyleBox["re-execute the first cell in the Implementation section below and \
check the next cell again",
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[Sum]\)], "Input"],

Cell[BoxData[
    \({Protected, ReadProtected}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["ClearAttributes",
    FontWeight->"Bold"],
  " and ",
  StyleBox["SetAttributes",
    FontWeight->"Bold"],
  " as necessary to obtain tis result."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The function to be substituted"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This function generates the proper form for the function to be assumed.\n\
Side-effects: ",
  StyleBox["CoefficientName ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "is defined globally for subsequent use. \nInstead of 'c' you cam use any \
valid name you like."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[y, x, c]\), "\n", 
    \(y[x_] = MakeAssumedFunction[x, c]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Sum]\+\(k = 0\)\%\[Omega] x\^k\ c[k]\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute y[x] into the operator Op[x, y]", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormalSeriesResult = Op[x, y]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Sum]\+\(k = 0\)\%\[Omega]\((\(-1\) + k)\)\ k\ x\^\(\(-2\) + k\)\ c[
            k] + \((2\ x + x\^2)\)\ \(\[Sum]\+\(k = 0\)\%\[Omega] 
            k\ x\^\(\(-1\) + k\)\ c[k]\) + \((4 + 
            x)\)\ \(\[Sum]\+\(k = 0\)\%\[Omega] x\^k\ c[k]\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormalPowerSeries = FormalSeriesResult //. CoeffToSum\)], "Input"],

Cell[BoxData[
    \(\[Sum]\+\(k = 0\)\%\[Omega]\((\(-1\) + k)\)\ k\ x\^\(\(-2\) + k\)\ c[
            k] + \[Sum]\+\(k = 0\)\%\[Omega] 
          4\ x\^k\ c[k] + \[Sum]\+\(k = 0\)\%\[Omega] 
          2\ k\ x\^k\ c[k] + \[Sum]\+\(k = 0\)\%\[Omega] x\^\(1 + k\)\ c[
            k] + \[Sum]\+\(k = 0\)\%\[Omega] 
          k\ x\^\(1 + k\)\ c[k]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Manipulate the Formal Series"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Begin the analysis process. Each term in  ",
  StyleBox["FormalPowerSeries ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "should be zero in order for our assumed series to be a solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(step1 = FormalPowerSeries //. RemoveZeroTerms\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Sum]\+\(k = 2\)\%\[Omega]\((\(-1\) + k)\)\ k\ x\^\(\(-2\) + k\)\ c[
            k] + \[Sum]\+\(k = 0\)\%\[Omega] 
          4\ x\^k\ c[k] + \[Sum]\+\(k = 1\)\%\[Omega] 
          2\ k\ x\^k\ c[k] + \[Sum]\+\(k = 0\)\%\[Omega] x\^\(1 + k\)\ c[
            k] + \[Sum]\+\(k = 1\)\%\[Omega] 
          k\ x\^\(1 + k\)\ c[k]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(step2 = step1 //. IncorporateFactors\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Sum]\+\(k = 2\)\%\[Omega]\((\(-1\) + k)\)\ k\ x\^\(\(-2\) + k\)\ c[
            k] + \[Sum]\+\(k = 0\)\%\[Omega] 
          4\ x\^k\ c[k] + \[Sum]\+\(k = 1\)\%\[Omega] 
          2\ k\ x\^k\ c[k] + \[Sum]\+\(k = 0\)\%\[Omega] x\^\(1 + k\)\ c[
            k] + \[Sum]\+\(k = 1\)\%\[Omega] 
          k\ x\^\(1 + k\)\ c[k]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Subscript Limits", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
DeterminingSet = 
 Map[ToExponentExcess, Apply[List,step2]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(-2\), 0, 0, 1, 1}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(subMax = Max[DeterminingSet]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(subMin = Min[DeterminingSet]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-2\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
SubscriptSet = 
  StepsToList[step2] //. GetSubscripts\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({2, 0, 1, 0, 1}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubscriptMax = Max[SubscriptSet]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Continue FormalSeries Manipulations", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Make all powers of x the same.", "Text",
  FormatType->TextForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(step3 = step2 //. AdjustIndices\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Sum]\+\(k = 1\)\%\[Omega] x\^k\ c[\(-1\) + 
              k] + \[Sum]\+\(k = 2\)\%\[Omega]\((\(-1\) + 
              k)\)\ x\^k\ c[\(-1\) + k] + \[Sum]\+\(k = 0\)\%\[Omega] 
          4\ x\^k\ c[k] + \[Sum]\+\(k = 1\)\%\[Omega] 
          2\ k\ x\^k\ c[
            k] + \[Sum]\+\(k = 0\)\%\[Omega]\((1 + k)\)\ \((2 + k)\)\ x\^k\ c[
            2 + k]\)], "Output"]
}, Closed]],

Cell["\<\
Pull out initial terms that do not belong in the common \
summation.\
\>", "Text",
  FormatType->TextForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(step4 = step3 /. EqualizeInitialIndices[SubscriptMax]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ c[0] + x\ c[0] + 6\ x\ c[1] + 2\ c[2] + 
      6\ x\ c[3] + \[Sum]\+\(k = 2\)\%\[Omega] x\^k\ c[\(-1\) + 
              k] + \[Sum]\+\(k = 2\)\%\[Omega]\((\(-1\) + 
              k)\)\ x\^k\ c[\(-1\) + k] + \[Sum]\+\(k = 2\)\%\[Omega] 
          4\ x\^k\ c[k] + \[Sum]\+\(k = 2\)\%\[Omega] 
          2\ k\ x\^k\ c[
            k] + \[Sum]\+\(k = 2\)\%\[Omega]\((1 + k)\)\ \((2 + k)\)\ x\^k\ c[
            2 + k]\)], "Output"]
}, Closed]],

Cell["Make common sums into one sum.", "Text",
  FormatType->TextForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(step5 = step4 //. CombineSeries\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ c[0] + x\ c[0] + 6\ x\ c[1] + 2\ c[2] + 
      6\ x\ c[3] + \[Sum]\+\(k = 2\)\%\[Omega]\((x\^k\ c[\(-1\) + 
                  k] + \((\(-1\) + k)\)\ x\^k\ c[\(-1\) + k] + 
            4\ x\^k\ c[k] + 
            2\ k\ x\^k\ c[k] + \((1 + k)\)\ \((2 + k)\)\ x\^k\ c[
                2 + k])\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(step6 = step5 /. CollectInitialTerms[x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ c[0] + 2\ c[2] + 
      x\ \((c[0] + 6\ c[1] + 
            6\ c[3])\) + \[Sum]\+\(k = 2\)\%\[Omega]\((x\^k\ c[\(-1\) + 
                  k] + \((\(-1\) + k)\)\ x\^k\ c[\(-1\) + k] + 
            4\ x\^k\ c[k] + 
            2\ k\ x\^k\ c[k] + \((1 + k)\)\ \((2 + k)\)\ x\^k\ c[
                2 + k])\)\)], "Output"]
}, Closed]],

Cell["Collect like terms inside the summation.", "Text",
  FormatType->TextForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(step7 = step6 //. CollectSeriesTerms\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ c[0] + 2\ c[2] + 
      x\ \((c[0] + 6\ c[1] + 
            6\ c[3])\) + \[Sum]\+\(k = 2\)\%\[Omega] x\^k\ \((c[\(-1\) + 
                  k] + \((\(-1\) + k)\)\ c[\(-1\) + k] + 4\ c[k] + 
              2\ k\ c[k] + \((1 + k)\)\ \((2 + k)\)\ c[2 + k])\)\)], "Output"]
}, Closed]],

Cell["Simplify the individual summation terms.", "Text",
  FormatType->TextForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(step8 = step7 //. CollectCoefficientTerms\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ c[0] + 2\ c[2] + 
      x\ \((c[0] + 6\ c[1] + 
            6\ c[3])\) + \[Sum]\+\(k = 2\)\%\[Omega] x\^k\ \((k\ c[\(-1\) + 
                    k] + \((4 + 2\ k)\)\ c[k] + \((1 + k)\)\ \((2 + k)\)\ c[
                  2 + k])\)\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The final series form"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["This is the series that we wanted.", "Text",
  FormatType->TextForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(final = step8 //. FactorCoefficientTerms\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ c[0] + 2\ c[2] + 
      x\ \((c[0] + 6\ c[1] + 
            6\ c[3])\) + \[Sum]\+\(k = 2\)\%\[Omega] x\^k\ \((k\ c[\(-1\) + 
                    k] + 2\ \((2 + k)\)\ c[k] + \((1 + k)\)\ \((2 + k)\)\ c[
                  2 + k])\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Recursion Relation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
RecursionRelation = 
  final /. (p_) + Sum[(c_)*(x_)^(k_), 
      {k_, s_, \[Omega]}] -> {c == 0, k >= s}\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({k\ c[\(-1\) + k] + 
          2\ \((2 + k)\)\ c[k] + \((1 + k)\)\ \((2 + k)\)\ c[2 + k] == 0, 
      k \[GreaterEqual] 2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AllRecursionRelations[k_] = 
      RecursionRelation\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \(k\ c[\(-1\) + k] + 
        2\ \((2 + k)\)\ c[k] + \((1 + k)\)\ \((2 + k)\)\ c[2 + k] == 
      0\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Initial Equations", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
InitialTerms = 
  final /. (p_) + Sum[(c_)*(x_)^(k_), 
      {k_, s_, \[Omega]}] :> p\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ c[0] + 2\ c[2] + x\ \((c[0] + 6\ c[1] + 6\ c[3])\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CoefficientList[InitialTerms, x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({4\ c[0] + 2\ c[2], c[0] + 6\ c[1] + 6\ c[3]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InitialEquations = 
      Function[e, e == 0] /@ 
        Flatten[CoefficientList[InitialTerms, x]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({4\ c[0] + 2\ c[2] == 0, c[0] + 6\ c[1] + 6\ c[3] == 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equate Coefficients to 0 (Using n=10, by default)", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(n = 10\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    \(10\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[EquationList]\), "\n", 
    \(EquationList[r_] = 
      Join[InitialEquations, 
        Table[AllRecursionRelations[k], {k, subMax, n}]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({4\ c[0] + 2\ c[2] == 0, c[0] + 6\ c[1] + 6\ c[3] == 0, 
      c[0] + 6\ c[1] + 6\ c[3] == 0, 2\ c[1] + 8\ c[2] + 12\ c[4] == 0, 
      3\ c[2] + 10\ c[3] + 20\ c[5] == 0, 4\ c[3] + 12\ c[4] + 30\ c[6] == 0, 
      5\ c[4] + 14\ c[5] + 42\ c[7] == 0, 6\ c[5] + 16\ c[6] + 56\ c[8] == 0, 
      7\ c[6] + 18\ c[7] + 72\ c[9] == 0, 
      8\ c[7] + 20\ c[8] + 90\ c[10] == 0, 
      9\ c[8] + 22\ c[9] + 110\ c[11] == 0, 
      10\ c[9] + 24\ c[10] + 132\ c[12] == 0}\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The general series solution(s)", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(TheCoefficients = 
      Table[CoefficientName[n - subMin - j], {j, 0, n - subMin}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({c[12], c[11], c[10], c[9], c[8], c[7], c[6], c[5], c[4], c[3], c[2], 
      c[1], c[0]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CoeffRules = GetCoeffRules\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{c[
            12] \[Rule] \(-\(\(13037\ c[
                      0]\)\/1360800\)\) - \(8137\ c[1]\)\/997920, 
        c[11] \[Rule] \(-\(\(32783\ c[0]\)\/997920\)\) + \(37\ c[1]\)\/6600, 
        c[10] \[Rule] \(3\ c[0]\)\/1400 + \(61\ c[1]\)\/1620, 
        c[9] \[Rule] \(5503\ c[0]\)\/45360 + \(29\ c[1]\)\/1680, 
        c[8] \[Rule] \(529\ c[0]\)\/5040 - \(31\ c[1]\)\/280, 
        c[7] \[Rule] \(-\(\(361\ c[0]\)\/1260\)\) - \(37\ c[1]\)\/252, 
        c[6] \[Rule] \(-\(\(23\ c[0]\)\/45\)\) + c[1]\/5, 
        c[5] \[Rule] \(23\ c[0]\)\/60 + c[1]\/2, 
        c[4] \[Rule] \(4\ c[0]\)\/3 - c[1]\/6, 
        c[3] \[Rule] \(-\(c[0]\/6\)\) - c[1], 
        c[2] \[Rule] \(-2\)\ c[0]}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["soln[x_] = TheSolution", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(c[0]\), "+", \(c[1]\ x\), "-", \(2\ c[0]\ x\^2\), 
        "+", \(\((\(-\(c[0]\/6\)\) - c[1])\)\ x\^3\), 
        "+", \(\((\(4\ c[0]\)\/3 - c[1]\/6)\)\ x\^4\), 
        "+", \(\((\(23\ c[0]\)\/60 + c[1]\/2)\)\ x\^5\), 
        "+", \(\((\(-\(\(23\ c[0]\)\/45\)\) + c[1]\/5)\)\ x\^6\), 
        "+", \(\((\(-\(\(361\ c[0]\)\/1260\)\) - \(37\ c[1]\)\/252)\)\ x\^7\),
         "+", \(\((\(529\ c[0]\)\/5040 - \(31\ c[1]\)\/280)\)\ x\^8\), 
        "+", \(\((\(5503\ c[0]\)\/45360 + \(29\ c[1]\)\/1680)\)\ x\^9\), 
        "+", \(\((\(3\ c[0]\)\/1400 + \(61\ c[1]\)\/1620)\)\ x\^10\), 
        "+", \(\((\(-\(\(32783\ c[
                        0]\)\/997920\)\) + \(37\ c[1]\)\/6600)\)\ x\^11\), 
        "+", \(\((\(-\(\(13037\ c[
                        0]\)\/1360800\)\) - \(8137\ c[1]\)\/997920)\)\ \
x\^12\), "+", 
        InterpretationBox[\(O[x]\^13\),
          SeriesData[ x, 0, {}, 0, 13, 1]]}],
      SeriesData[ x, 0, {
        c[ 0], 
        c[ 1], 
        Times[ -2, 
          c[ 0]], 
        Plus[ 
          Times[ 
            Rational[ -1, 6], 
            c[ 0]], 
          Times[ -1, 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ 4, 3], 
            c[ 0]], 
          Times[ 
            Rational[ -1, 6], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ 23, 60], 
            c[ 0]], 
          Times[ 
            Rational[ 1, 2], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ -23, 45], 
            c[ 0]], 
          Times[ 
            Rational[ 1, 5], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ -361, 1260], 
            c[ 0]], 
          Times[ 
            Rational[ -37, 252], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ 529, 5040], 
            c[ 0]], 
          Times[ 
            Rational[ -31, 280], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ 5503, 45360], 
            c[ 0]], 
          Times[ 
            Rational[ 29, 1680], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ 3, 1400], 
            c[ 0]], 
          Times[ 
            Rational[ 61, 1620], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ -32783, 997920], 
            c[ 0]], 
          Times[ 
            Rational[ 37, 6600], 
            c[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ -13037, 1360800], 
            c[ 0]], 
          Times[ 
            Rational[ -8137, 997920], 
            c[ 1]]]}, 0, 13, 1]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check the solution", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Op[x, soln]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[\(O[x]\^11\),
      SeriesData[ x, 0, {}, 11, 11, 1]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Linearly Independent Solutions", "Subsection",
  FormatType->TextForm],

Cell["\<\
The number of solutions to be obtained here depends on the order of \
the differential operator. Modify these lines as necessary.\
\>", "Text",
  FormatType->TextForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = soln[x] /. {c[0] \[Rule] 1, c[1] \[Rule] 0}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "-", \(2\ x\^2\), "-", \(x\^3\/6\), "+", \(\(4\ x\^4\)\/3\), 
        "+", \(\(23\ x\^5\)\/60\), "-", \(\(23\ x\^6\)\/45\), 
        "-", \(\(361\ x\^7\)\/1260\), "+", \(\(529\ x\^8\)\/5040\), 
        "+", \(\(5503\ x\^9\)\/45360\), "+", \(\(3\ x\^10\)\/1400\), 
        "-", \(\(32783\ x\^11\)\/997920\), "-", \(\(13037\ x\^12\)\/1360800\),
         "+", 
        InterpretationBox[\(O[x]\^13\),
          SeriesData[ x, 0, {}, 0, 13, 1]]}],
      SeriesData[ x, 0, {1, 0, -2, 
        Rational[ -1, 6], 
        Rational[ 4, 3], 
        Rational[ 23, 60], 
        Rational[ -23, 45], 
        Rational[ -361, 1260], 
        Rational[ 529, 5040], 
        Rational[ 5503, 45360], 
        Rational[ 3, 1400], 
        Rational[ -32783, 997920], 
        Rational[ -13037, 1360800]}, 0, 13, 1]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x_] = soln[x] /. {c[0] \[Rule] 0, c[1] \[Rule] 1}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "x", "-", \(x\^3\), "-", \(x\^4\/6\), "+", \(x\^5\/2\), 
        "+", \(x\^6\/5\), "-", \(\(37\ x\^7\)\/252\), 
        "-", \(\(31\ x\^8\)\/280\), "+", \(\(29\ x\^9\)\/1680\), 
        "+", \(\(61\ x\^10\)\/1620\), "+", \(\(37\ x\^11\)\/6600\), 
        "-", \(\(8137\ x\^12\)\/997920\), "+", 
        InterpretationBox[\(O[x]\^13\),
          SeriesData[ x, 0, {}, 1, 13, 1]]}],
      SeriesData[ x, 0, {1, 0, -1, 
        Rational[ -1, 6], 
        Rational[ 1, 2], 
        Rational[ 1, 5], 
        Rational[ -37, 252], 
        Rational[ -31, 280], 
        Rational[ 29, 1680], 
        Rational[ 61, 1620], 
        Rational[ 37, 6600], 
        Rational[ -8137, 997920]}, 1, 13, 1]]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Implementation", "Section",
  Editable->False,
  InitializationCell->True,
  FormatType->TextForm,
  FontColor->RGBColor[0, 0, 1]],

Cell["It is unwise to modify any of these definitions!", "Text",
  FormatType->TextForm,
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[TextData[{
  "(* ",
  StyleBox["Execute this cell again, if necessary",
    FontVariations->{"Underline"->True}],
  " *)",
  "\nUnprotect[Sum];\nAttributes[Sum]={Protected,ReadProtected};\n\
Protect[Sum];"
}], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[{
    \(\(Off[General::spell1];\)\), "\n", 
    \(\(CoefficientName;\)\), "\n", 
    \(\(On[General::spell1];\)\)}], "Input",
  InitializationCell->True],

Cell["\<\
Clear[MakeAssumedFunction]
MakeAssumedFunction[x_, CoeffName_] := 
  Module[{}, CoefficientName = CoeffName; 
    Sum[CoeffName[k]*x^k, {k, 0, \[Omega]}]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["Clear[StepsToList]; StepsToList[expr_] := List @@ expr; ", "Input",
  InitializationCell->True],

Cell["\<\
Clear[ToExponentExcess]
ToExponentExcess[Sum[(q_)*x^(k + (p_.)), 
    {k, s_, \[Omega]}]] := p\
\>", "Input",
  InitializationCell->True],

Cell["StepsToList[expr_] := List @@ expr", "Input",
  InitializationCell->True],

Cell[BoxData[
    \(GetCoeffRules := 
      Module[{s}, 
        Off[Solve::svars]; \n\t\ts = 
          Solve[Flatten[EquationList[0]], TheCoefficients]; \n
        On[Solve::svars]; s]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(TheSolution := \((\(MakeAssumedFunction[x, \ 
                CoefficientName]\  /. \ \[Omega]\  -> \ 
                n\  - \ subMin\)\  /. \ 
            CoeffRules[\([1]\)])\)\  + \ \n\ \ \ O[
            x]^\((n\  - \ subMin\  + \ 1)\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Transformation*Rules", "Subsection",
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CoeffToSum := \((u_.  + v_. )\)\ \(\[Sum]\+\(p_ = q_\)\%r_ 
            s_\) \[RuleDelayed] \[Sum]\+\(p = q\)\%r 
              u\ s + \[Sum]\+\(p = q\)\%r v\ s\)], "Input",
  InitializationCell->True],

Cell["\<\
ToIndividualSums = 
   (a_.)*Sum[(p1_) + (p2_), {k_, s_, \[Omega]}] :> 
    a*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
GetSubscripts = 
   Sum[(a_.)*x^((k_) + (p_.)), {k, s_, \[Omega]}] :> s;\
\>", "Input",
  InitializationCell->True],

Cell["\<\
RemoveZeroTerms = 
   Sum[(c_)*(x_)^(p_), {k_, a_, \[Omega]}] :> 
    Sum[c*x^p, {k, a + 1, \[Omega]}] /; (c /. k -> a) == 0; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
IncorporateFactors = 
   ((a_.) + (b_))*Sum[c_, {k_, s_, \[Omega]}] :> 
    Sum[a*c, {k, s, \[Omega]}] + Sum[b*c, {k, s, \[Omega]}];\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
AdjustIndices = 
   Sum[(c_)*(x_)^((k_) + (q_)), {k_, s_, \[Omega]}] :> 
    Sum[(c /. k :> k - q)*x^k, {k, s + q, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Clear[EqualizeInitialIndices]
EqualizeInitialIndices[subMax_] := 
  Sum[c_, {k_, s_, \[Omega]}] :> 
   Sum[c, {k, s, subMax - 1}] + 
     Sum[c, {k, subMax, \[Omega]}] /; s < subMax\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CombineSeries = 
   Sum[c_, {k_, s_, \[Omega]}] + 
     Sum[d_, {k_, s_, \[Omega]}] :> 
    Sum[c + d, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectInitialTerms[x_] = 
   (p_) + Sum[c_, {k_, s_, \[Omega]}] :> 
    Collect[p, x] + Sum[c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectSeriesTerms = 
   Sum[(x_)^(k_)*(c1_.) + (x_)^(k_)*(d1_.) + (e1_.), 
     {k_, s_, \[Omega]}] :> 
    Sum[x^k*(c1 + d1) + e1, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectCoefficientTerms = 
   Sum[(x_)^(k_)*((c1_.)*(c_)[p_] + (d1_.)*(c_)[p_] + (e1_.)), {k_, s_, \
\[Omega]}] :> 
    Sum[x^k*((c1 + d1)*c[p] + e1), {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
FactorCoefficientTerms = 
   (c1_)*(c_)[p_] :> Factor[c1]*c[p]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{562, 537},
WindowMargins->{{0, Automatic}, {Automatic, 21}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 159, 6, 88, "Subtitle",
  Evaluatable->False],
Cell[1938, 61, 153, 4, 42, "Text"],
Cell[2094, 67, 812, 21, 158, "Text",
  Evaluatable->False],
Cell[2909, 90, 348, 11, 32, "Text"],

Cell[CellGroupData[{
Cell[3282, 105, 126, 2, 56, "Section",
  Evaluatable->False],
Cell[3411, 109, 51, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[3487, 114, 82, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3594, 120, 223, 6, 47, "Input"],
Cell[3820, 128, 344, 8, 29, "Output"]
}, Closed]],
Cell[4179, 139, 414, 11, 68, "Text"],

Cell[CellGroupData[{
Cell[4618, 154, 48, 1, 27, "Input"],
Cell[4669, 157, 60, 1, 27, "Output"]
}, Closed]],
Cell[4744, 161, 196, 8, 32, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[4977, 174, 110, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5090, 178, 353, 10, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5468, 192, 125, 3, 43, "Input"],
Cell[5596, 197, 72, 1, 50, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5729, 205, 109, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5863, 211, 88, 2, 27, "Input"],
Cell[5954, 215, 282, 4, 50, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6273, 224, 86, 1, 27, "Input"],
Cell[6362, 227, 356, 6, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6767, 239, 105, 2, 36, "Section",
  Evaluatable->False],
Cell[6875, 243, 277, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7177, 255, 104, 2, 27, "Input"],
Cell[7284, 259, 356, 6, 94, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7677, 270, 95, 2, 27, "Input"],
Cell[7775, 274, 356, 6, 94, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8168, 285, 86, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8279, 291, 138, 5, 42, "Input",
  InitializationCell->True],
Cell[8420, 298, 54, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8511, 304, 87, 2, 27, "Input"],
Cell[8601, 308, 35, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8673, 314, 87, 2, 27, "Input"],
Cell[8763, 318, 40, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8840, 324, 105, 4, 42, "Input"],
Cell[8948, 330, 49, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9034, 336, 91, 2, 27, "Input"],
Cell[9128, 340, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9212, 347, 105, 2, 46, "Subsection",
  Evaluatable->False],
Cell[9320, 351, 70, 1, 32, "Text"],

Cell[CellGroupData[{
Cell[9415, 356, 90, 2, 27, "Input"],
Cell[9508, 360, 387, 7, 94, "Output"]
}, Closed]],
Cell[9910, 370, 116, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[10051, 378, 112, 2, 27, "Input"],
Cell[10166, 382, 450, 8, 113, "Output"]
}, Closed]],
Cell[10631, 393, 70, 1, 32, "Text"],

Cell[CellGroupData[{
Cell[10726, 398, 90, 2, 27, "Input"],
Cell[10819, 402, 329, 6, 89, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[11185, 413, 98, 2, 27, "Input"],
Cell[11286, 417, 342, 7, 89, "Output"]
}, Closed]],
Cell[11643, 427, 80, 1, 32, "Text"],

Cell[CellGroupData[{
Cell[11748, 432, 95, 2, 27, "Input"],
Cell[11846, 436, 291, 5, 88, "Output"]
}, Closed]],
Cell[12152, 444, 80, 1, 32, "Text"],

Cell[CellGroupData[{
Cell[12257, 449, 100, 2, 27, "Input"],
Cell[12360, 453, 266, 5, 69, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12687, 465, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[12788, 469, 74, 1, 32, "Text"],

Cell[CellGroupData[{
Cell[12887, 474, 99, 2, 27, "Input"],
Cell[12989, 478, 266, 5, 69, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13304, 489, 99, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13428, 495, 156, 5, 57, "Input"],
Cell[13587, 502, 156, 3, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[13780, 510, 155, 4, 27, "Input"],
Cell[13938, 516, 131, 3, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14106, 524, 87, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14218, 530, 136, 5, 57, "Input"],
Cell[14357, 537, 87, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14481, 543, 91, 2, 27, "Input"],
Cell[14575, 547, 79, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14691, 553, 158, 4, 59, "Input"],
Cell[14852, 559, 89, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14990, 566, 119, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15134, 572, 131, 4, 43, "Input"],
Cell[15268, 578, 36, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15341, 584, 203, 5, 75, "Input"],
Cell[15547, 591, 499, 8, 107, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16107, 606, 97, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16229, 612, 142, 3, 43, "Input"],
Cell[16374, 617, 122, 2, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[16533, 624, 85, 2, 27, "Input"],
Cell[16621, 628, 728, 13, 178, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17386, 646, 65, 1, 27, "Input"],
Cell[17454, 649, 2667, 91, 178, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[20158, 745, 88, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20271, 751, 78, 2, 27, "Input"],
Cell[20352, 755, 101, 2, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20502, 763, 76, 1, 46, "Subsection"],
Cell[20581, 766, 177, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[20783, 774, 111, 2, 27, "Input"],
Cell[20897, 778, 873, 21, 82, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[21807, 804, 111, 2, 27, "Input"],
Cell[21921, 808, 761, 19, 82, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22743, 834, 136, 4, 36, "Section",
  InitializationCell->True],
Cell[22882, 840, 158, 4, 34, "Text"],
Cell[23043, 846, 283, 9, 72, "Input",
  InitializationCell->True],
Cell[23329, 857, 166, 4, 59, "Input",
  InitializationCell->True],
Cell[23498, 863, 233, 7, 72, "Input",
  InitializationCell->True],
Cell[23734, 872, 101, 1, 42, "Input",
  InitializationCell->True],
Cell[23838, 875, 147, 5, 57, "Input",
  InitializationCell->True],
Cell[23988, 882, 79, 1, 27, "Input",
  InitializationCell->True],
Cell[24070, 885, 227, 6, 75, "Input",
  InitializationCell->True],
Cell[24300, 893, 300, 6, 75, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[24625, 903, 118, 3, 46, "Subsection",
  Evaluatable->False,
  InitializationCell->True],
Cell[24746, 908, 221, 4, 52, "Input",
  InitializationCell->True],
Cell[24970, 914, 216, 7, 57, "Input",
  InitializationCell->True],
Cell[25189, 923, 125, 4, 42, "Input",
  InitializationCell->True],
Cell[25317, 929, 205, 6, 72, "Input",
  InitializationCell->True],
Cell[25525, 937, 211, 6, 57, "Input",
  InitializationCell->True],
Cell[25739, 945, 206, 6, 57, "Input",
  InitializationCell->True],
Cell[25948, 953, 260, 8, 87, "Input",
  InitializationCell->True],
Cell[26211, 963, 201, 7, 72, "Input",
  InitializationCell->True],
Cell[26415, 972, 194, 6, 57, "Input",
  InitializationCell->True],
Cell[26612, 980, 231, 7, 87, "Input",
  InitializationCell->True],
Cell[26846, 989, 249, 7, 72, "Input",
  InitializationCell->True],
Cell[27098, 998, 143, 5, 42, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

